/**
 * Created by kuruczd on 3/20/14.
 */

'use strict';
define([ 'jquery' ], function ($) {
    return (function () {
        var _popupFix = {};

        _popupFix.register = function register() {
            var divertFocus = function(el, e){
                el.focus();
                e.preventDefault();
                return false;
            }

            //fix for tabbing out of the windows or tabbing being stuck
            $(document).on('keydown', '.ui-popup-active', function(e) {
                if(e.which === 9){
                    var elems = $(e.currentTarget).find("a[href], link[href], button, input, select, textarea, div[draggable]").not("[style='display:none']");
                    if(document.activeElement == elems[0] && e.shiftKey){
                        return divertFocus(elems[elems.length - 1], e);
                    }
                    else if(document.activeElement == elems[elems.length - 1] && !e.shiftKey){
                        return divertFocus(elems[0], e);
                    }
                }
            });

            //fix for escape on the panel closing the panel at all times
            $(document).on('keyup', '.ui-popup-active', function(e) {
                if(e.which === 27){
                    e.preventDefault();
                    $("#" + e.currentTarget.id + " > div").popup("close");
                    return false;
                }
            });
        };

        return _popupFix;
    }());
});